function p = convertX(x)

% p = convertX(x)
%
% Input Variables
%   x - parameters for the ecgGen that are to be estimated
%
% Output Variables
%   p - structure format for x
%
% Description
%   Converts format of paramters
% Created
%   4/22/2006, Richard J. Povinelli, Marquette University
%
% Modified
%   Mohamed A Mneimneh, Marquette University
% 
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).

%rename the x values
[regions featuresPerModel] = getRegions();
for i = 1:length(regions)
    %sigmoid parameters, inflection points start at 1, slopes at 9
    index = (i-1) * 2 + 1; %2 inflection points & 2 slopes per regions
    p.(regions{i}).sig = [x(index+2*length(regions)) x(index) x(index+2*length(regions)+1) x(index+1)];

    %magnitude of the regions signal
    index = (i-1) + 4*length(regions)+1; %magnitudes start at x(17)
    p.(regions{i}).mag = x(index);

    %delays start at 21, positive than negative
    index = (i-1) * 4 + 5*length(regions)+1; %2 inflection points & 2 slopes per regions
    p.(regions{i}).posDelta1 = x(index);
    p.(regions{i}).posDelta2 = x(index+1);
    p.(regions{i}).negDelta1 = x(index + 2);
    p.(regions{i}).negDelta2 = x(index + 3);
end %for